<?php

///////////////////////////////////////////////////////////////////////////////////////////////////////
// BotBanish 7.0.12
// Randem Systems: https://randemsystems.support
// Delete All BotBanish Data, Tables and Files
// Date: 01/12/2026
// Usage: BotBanishInstallCleanup.php?system=SMF
//
// system parameter can be smf, wordpress or website
///////////////////////////////////////////////////////////////////////////////////////////////////////
	
	$system = isset($_GET['system']) ? strtoupper($_GET['system']) : '';
	$system = empty($system) && isset($_POST['system']) ? strtoupper($_POST['system']) : $system;

	$version = isset($_GET['version']) ? strtoupper($_GET['version']) : '';
	
	if (empty($system) || empty($version)) {
		
		echo ' Parameter missing. Must be BotBanishInstallCleanup.php?system=parameter&version=version
		wparameter is smf, wordpress or website
		version is the actual version number to uninstall. (ex. 7.0.00)';
		exit;
	}
		
	require 'BotBanishDatabaseRtns.php';
	require 'BotBanishCleanupRtns.php';
			
	// Get to the install folder of the system
	
	$root = realpath(getcwd() . '/../');
	chdir($root);

	BotBanishBrowserNoCache();
	echo 'BotBanish System Cleanup Started<br><br>';

	BotBanishSetGlobals();
	
	switch ($system) {
		
		case 'WORDPRESS':
		
			define('WORDPRESS', 1);
			BotBanishProcessWPSettingsFile();
			require 'BotBanish_WP_Settings.php';

			$dbInfo = array(
					'DB_TABLE_PREFIX' => $table_prefix,
					'DB_NAME' => DB_NAME,
					'DB_USER' => DB_USER,
					'DB_PASSWORD' => DB_PASSWORD,
					'DB_HOST' => DB_HOST,
					'DB_PORT' => '',
					'DB_COLLATE' => DB_COLLATE,
					'DB_CHARSET' => DB_CHARSET,
				);			
			
			define('BOTBANISH_DIR', ABSPATH . '/wp-content/plugins/BotBanish_Client_WordPress_v' . $version . '/bot/');
			break;
			
		case 'SMF':
		
			define('SMF', 1);
			require 'Settings.php';

			$dbInfo = array(
					'DB_TABLE_PREFIX' => $db_prefix,
					'DB_NAME' => $db_name,
					'DB_USER' => $db_user,
					'DB_PASSWORD' => $db_passwd,
					'DB_HOST' => $db_server,
					'DB_PORT' => $db_port,
					'DB_COLLATE' => '',
					'DB_CHARSET' => ''
				);		
			
			define('BOTBANISH_DIR', $boarddir . '/BotBanish/bot/');
			$themedir = $boarddir . '/Themes/default';
			BotBanishRemoveCode();
			break;
			
		case 'WEBSITE':
			
			$dbInfo = array(
					'DB_TABLE_PREFIX' => 'bbc_',
					'DB_NAME' => $db_name,
					'DB_USER' => $db_user,
					'DB_PASSWORD' => $db_passwd,
					'DB_HOST' => $db_server,
					'DB_PORT' => '',
					'DB_COLLATE' => '',
					'DB_CHARSET' => ''
				);
				
			define('BOTBANISH_DIR', $_SERVER['DOCUMENT_ROOT'] . '/BotBanish/bot/');
			break;
	}
	
	BotBanishSetDBGlobals($dbInfo);

	switch ($system) {
	
		case 'SMF':

			BotBanishRemoveHooks();			
			BotBanishRemovePackageList();
			break;
	}
	
	$folders = BotBanishFolderDeletion();
	BotBanishTableDeletion($folders, $system);
	BotBanishFileDeletion($folders, $system);
	
	BotBanishCleanupHTACCESS();

	echo '<br>BotBanish System Cleanup Complete<br><br>';
?>