<?php
///////////////////////////////////////////////////////////////////////////////////////////////////////
// BotBanish 7.0.11
// Randem Systems: https://randemsystems.support
// Stand Alone Database Routines
// Date: 01/09/2026
// Usage: include BotBanishDatabaseRtns.ph
//
///////////////////////////////////////////////////////////////////////////////////////////////////////

function BotBanishBrowserNoCache() {
	
	// Set headers to prevent caching
	header("Expires: Tue, 01 Jan 2000 00:00:00 GMT");
	header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
	header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
	header("Cache-Control: post-check=0, pre-check=0", false);
	header("Pragma: no-cache");
}

function BotBanishProcessWPSettingsFile() {

	$data = file_get_contents('wp-config.php');

	// Eliminate loading of wp-settings.php. We only want the defines

	$data = str_ireplace('require', '// require', $data) . PHP_EOL . '?>';
	file_put_contents('BotBanish_WP_Settings.php', $data);
}

function BotBanishSetDBGlobals($dbInfo) {

	define('BOTBANISH_TABLE_PREFIX', $dbInfo['DB_TABLE_PREFIX']);

	define('BOTBANISH_DB_PORT', $dbInfo['DB_PORT']);
	define('BOTBANISH_DB_NAME', $dbInfo['DB_NAME']);
	define('BOTBANISH_DB_USERNAME', $dbInfo['DB_USER']);
	define('BOTBANISH_DB_PASSWORD', $dbInfo['DB_PASSWORD']);
	define('BOTBANISH_DB_HOST', $dbInfo['DB_HOST']);
	define('BOTBANISH_DATABASE_TABLE_COLLATION_DEFAULT', $dbInfo['DB_COLLATE']);
	define('BOTBANISH_DATABASE_TABLE_CHARSET_DEFAULT', $dbInfo['DB_CHARSET']);
}

function BotBanishExecuteSQL($sql) {

	$conn = BotBanishDatabaseOpen();

	mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);	// Allow mysqli error to be trapped

	$rows = array();
	$result = BotBanishPerformQuery($conn, $sql);

	if (is_object($result)) {

		$rows = BotBanishExtractResults($result);
		BotBanishResultRelease($result);
	}

	BotBanishDatabaseClose($conn);

	if (isset($rows[0]['error'])) {

		$subject = 'SQL Execute Error:';
		$body = $rows[0]['error'];
		echo $subject . '<br>' . $body . '<br>';
	}

	return $rows;
}

function BotBanishPerformQuery($conn, $sql_statement) {

	try {

		$result = mysqli_query($conn, $sql_statement);

	} catch (Exception $f) {

		echo 'SQL Query Error: ' . $sql_statement . '<br><br>' . $f . '<br>';
		$result = false;
	}

	return $result;
}

function BotBanishDatabaseOpen() {

	$conn = false;

	$data = BotBanishGetDatabaseInfo();

	mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);	// Allow mysqli error to be trapped

	try {

		$conn = mysqli_connect($data['server'], $data['username'], $data['password'], $data['database']);
		$conn->set_charset($data['charset']);
		$conn->query('"SET collation_connection = ' . $data['collation'] . '"');

	} catch (mysqli_sql_exception $e) {

		try {

			$conn = mysqli_connect($data['server'], $data['username'], $data['password'], $data['database']);

		} catch (mysqli_sql_exception $f) {

			echo 'Connection Failed:<br>';
			return false;
		}
	}

	return $conn;
}

function BotBanishGetDatabaseInfo() {

	$server_name = BOTBANISH_DB_HOST;
	$port = BOTBANISH_DB_PORT;
	$user_name = BOTBANISH_DB_USERNAME;
	$password = BOTBANISH_DB_PASSWORD;
	$database_name = BOTBANISH_DB_NAME;
	$collation = BOTBANISH_DATABASE_TABLE_COLLATION_DEFAULT;
	$charset = BOTBANISH_DATABASE_TABLE_CHARSET_DEFAULT;

	$database_info = array('server' => $server_name, 'username' => $user_name, 'password' => $password, 'database' => $database_name, 'collation' => $collation, 'charset' => $charset);
	return $database_info;
}

function BotBanishDatabaseClose($conn) {

	if (is_object($conn)) {

		if (isset($conn->server_info))
			mysqli_close($conn);
	}
}

function BotBanishShowBotBanishTableInfo($delete = false) {
	
	$sql = 'SHOW TABLE STATUS WHERE name LIKE "%botbanish%"';
	$tables = BotBanishExecuteSQL($sql);

	if (!empty($tables)) {

		echo '<table width="50%" cellpadding="0" cellspacing="0" border="0">
			<tr>
				<td colspan="3">Existing tables:</td>
			</tr>';
		
		echo '<tr style="background-color: #0099cc;"><td>Table Name</td><td>Engine</td><td>Rows</td><td>Collation</td></tr>';

		foreach ($tables as $table) {
			
			$sql = 'SELECT COUNT(*) FROM `' . $table['Name'] . '`';
			$rows = BotBanishExecuteSQL($sql);
			$count = $rows[0]['COUNT(*)'];
			
			if ($delete) {
				
				$sql = 'DROP TABLE `' . $table['Name'] . '`';
				BotBanishExecuteSQL($sql);
			}
			
			echo '<tr ><b><td>' . $table['Name'] . '</td><td>' . $table['Engine'] . '</td><td>' . $count . '</td><td>' . $table["Collation"] . '</td></b></tr>';
		}
		
		echo '</table>';
		
	} else {

		echo '<br>&emsp;No tables exist<br>';
	}
}

function BotBanishGetTableNames ($tablename, $actual = false) {

	$tables = array();

	$data = BotBanishGetDatabaseInfo();
	if (empty($data['server'])) return array();

	$sql = 'SELECT `TABLE_NAME` FROM information_schema.TABLES WHERE (`TABLE_SCHEMA` = "' . $data['database'] . '") AND (`TABLE_NAME` ';
	$sql .= ' LIKE "%' . $tablename . '%")';

	$rows = BotBanishExecuteSQL($sql, true, false);

	if (!empty($rows) && is_array($rows)) {

		// Strip off any quotes and or database name that may be in the prefix

		$db_name = str_replace('`', '', $data['database']);
		$pos = strripos($db_name, '.');

		if ($pos !== false)
			$db_name = substr($db_name, $pos + 1);

		foreach ($rows as $row) {

			$table = str_ireplace(array($db_name . '.', '`'), '', $row['TABLE_NAME']);
			$tables[] = $table;
		}
	}

	return $tables;
}

function BotBanishExtractResults($result) {

	$rows = array();
	$rowcount = -1;

	if (is_object($result)) {

		try {

			$rowcount = mysqli_num_rows($result);

		} catch (Exception $f) {

			$rows[0]['error'] = $f;
		}

		if ($rowcount > 0) {

			$rows = array();

			try {

				while ($row = mysqli_fetch_array($result, MYSQLI_ASSOC))
					$rows[] = $row;

			} catch (Exception $f) {

				$rows[0]['error'] = $f;
			}
		}

	} else {

		if ($result === false) {

			$rows[0]['error'] = 'BotBanish_ErrorText' . '<br>' . '<br>' . $sql . '<br>' . '<br>';
			$rows[0]['error'] .= mysqli_errno($conn) . ": " . mysqli_error($conn) . '<br>' . '<br>';

			global $db_server, $db_name;
			$rows[0]['error'] .= '<br>' . $db_server . '<br>' . $db_name. '<br>';
		}
	}

	return $rows;
}

function BotBanishResultRelease($result) {

	// Release any memory held by a mySQL query

	if (isset($result) && is_object($result)) {

		if (defined('OO')) {

			$result->free();
		}else{
			mysqli_free_result($result);
		}
	}
}

function BotBanishRemoveHooks() {

	$hooks = BotBanishGetHooks();
	
	foreach ($hooks as $hook)
		BotBanishRemoveIntegrationFunction($hook[0], $hook[1]);
}

function BotBanishGetHooks() {
	
	$hooks = array(
				array('integrate_pre_include', '$boarddir/BotBanish/bot/Include/BotBanish_PreIncludes.php', true),

			//	array('integrate_validate_login', 'BotBanishClient_CheckUserLogin', true),
				array('integrate_login', 'BotBanishClient_UserLoggedIn', true),
				array('integrate_register', 'BotBanishClient_CheckUserRegistration', true),

				array('integrate_pre_load', 'BotBanishClient_DetectSpider', true),
				array('integrate_error_types', 'BotBanishAddErrorTypes', true),
					
				// Black / White List UI

				array('integrate_pre_include', '$boarddir/BotBanish/bot/Subs/BotBanish_Subs_BlackWhiteLists.php', true),
				array('integrate_menu_buttons', 'BotBanishClient_AddMenuButtons', true),
				array('integrate_actions', 'BotBanishClient_AddActions', true),
				
				// Mail

				array('integrate_outgoing_email','BotBanishValidateContact_SMF', true),
				
				// Bans

				array('integrate_manage_bans','BotBanish_SMF_ManageBans', true),
				array('integrate_load_profile_fields','BotBanish_SMF_Profile_Modify', true),
				array('integrate_display_topic','BotBanish_SMF_Display', true),
				array('integrate_download_headers','BotBanish_SMF_ShowAttachments', true),
				array('integrate_activate','BotBanish_SMF_Register', true),
				array('integrate_preview_post','BotBanish_SMF_CheckUser', true),
				array('integrate_post_start','BotBanish_SMF_CheckUser', true),		
				array('integrate_pre_log_stats','BotBanish_SMF_CheckUser', true),		


			);
	
	return $hooks;
}

function BotBanishRemoveIntegrationFunction($hook, $function) {

	global $db_prefix;
	
	$table = $db_prefix . 'settings';
	
	$sql = 'SELECT value FROM `' . $table . '` WHERE variable = "' . $hook . '"';
	$rows = BotBanishExecuteSQL($sql);

	foreach ($rows as $row) {
		
		$arr = explode(',', $row['value']);
		
		foreach ($arr as $key => $value) {

			if ($value == $function)
				unset($arr[$key]);
		}
		
		$arr = array_filter($arr);
		
		if (!empty($arr)) {
			
			$str = implode(',', $arr);	
			$sql = 'UPDATE `' . $table . '` SET value = "' . $str . '" WHERE variable = "' . $hook . '"';
			
		} else {
			
			$sql = 'DELETE FROM `' . $table . '` WHERE variable = "' . $hook . '"';
		}
		
		BotBanishExecuteSQL($sql);
	}
}
?>