<?php

///////////////////////////////////////////////////////////////////////////////////////////////////////
// BotBanish 7.0.12
// Randem Systems: https://randemsystems.support
// Delete All BotBanish Data, Tables and Files
// Date: 01/10/2026
// Usage: require_once BotBanishDeleteTableData.php
//
///////////////////////////////////////////////////////////////////////////////////////////////////////

function BotBanishSetGlobals() {

	$char = '*';
	$start = str_repeat($char . ' ', 5);
	$end = str_repeat(' ' . $char, 5);
	$section = '# %s%s%s';

	define('BOTBANISH_TAG_IP_START', '# * * * * * BotBanish IP Start * * * * *');
	define('BOTBANISH_TAG_IP_END', '# * * * * * BotBanish IP End * * * * *');
	define('BOTBANISH_TAG_BOT_START', '# * * * * * BotBanish BOT Start * * * * *');
	define('BOTBANISH_TAG_BOT_END', '# * * * * * BotBanish BOT End * * * * *');

	define('BOTBANISH_CODE_START', '# * * * * * BotBanish CODE Start * * * * *');
	define('BOTBANISH_CODE_END', '# * * * * * BotBanish CODE End * * * * *');
	define('BOTBANISH_RULE_START', '# * * * * * BotBanish RULES Start * * * * *');
	define('BOTBANISH_RULE_END', '# * * * * * BotBanish RULES End * * * * *');

	define('BOTBANISH_XMLRPC_START', '# * * * * * BotBanish XMLRPC Start * * * * *');
	define('BOTBANISH_XMLRPC_END', '# * * * * * BotBanish XMLRPC End * * * * *');
	define('BOTBANISH_HTACCESS_START', '# * * * * * BotBanish HTACCESS Start * * * * *');
	define('BOTBANISH_HTACCESS_END', '# * * * * * BotBanish HTACCESS End * * * * *');
	define('BOTBANISH_WPCONFIG_START', '# * * * * * BotBanish WPCONFIG Start * * * * *');
	define('BOTBANISH_WPCONFIG_END', '# * * * * * BotBanish WPCONFIG End * * * * *');

	define('BOTBANISH_TAG_BOT_REWRITE_START', sprintf($section, $start, 'BotBanish BOT Start (REWRITECOND)', $end));
	define('BOTBANISH_TAG_BOT_REWRITE_END', sprintf($section, $start, 'BotBanish BOT End (REWRITECOND)', $end));
	define('BOTBANISH_HTACCESS_HEADER', '<br>' . '<br>' . '# Deny bandwidth, Spam, data and login attacks (BotBanish - ' . 'BOTBANISH_USER_HOST' . ')' . '<br>' . '<br>');
	define('BOTBANISH_REPLACE', '//	* * * * * BotBanish * * * * *');

	// .htaccess section headers and footers

	define('BOTBANISH_IP_HEADER_START', '<br>' . '<Limit GET POST>' . '<br>' . 'order allow,deny' . '<br>' . 'allow from all' . '<br>' . '</Limit>' . '<br>');
	define('BOTBANISH_BOT_HEADER_END', '<br>' . '<Limit GET POST HEAD>' . '<br>' . 'Order Allow,Deny' . '<br>' . 'Allow from all' . '<br>' . 'Deny from env=bad_bot' . '<br>' . '</Limit>' . '<br>');
	define('BOTBANISH_REQUIREALL_START_ORG', '<br>' . '<RequireAll>' . '<br>' . 'Require all granted' . '<br>');
	define('BOTBANISH_REQUIREALL_END_ORG', '<br>' . '</RequireAll>' . '<br>');
	define('BOTBANISH_REQUIREALL_START', '<br>' . '<Files *>' . '<br>' . '<RequireAll>' . '<br>' . 'Require all granted' . '<br>');
	define('BOTBANISH_REQUIREALL_END', '<br>' . '</RequireAll>' . '<br>' . '</Files>' . '<br>');
	define('BOTBANISH_EMPTY_REQUIRE', '<br>' . '<RequireAll>' . '<br>' . 'Require all granted' . '<br>' . '</RequireAll>' . '<br>');
	define('BOTBANISH_EMPTY_FILES', '<br>' . '<Files *>' . '<br>' . '</Files>' . '<br>');
	define('BOTBANISH_REWRITECOND_START', '<br>' . 'RewriteCond %{HTTP_USER_AGENT}' . '<br>');
//	define('BOTBANISH_REWRITECOND_END', '<br>' . 'RewriteRule .* - [G,L,E=bad_bot:Yes]' . '<br>');
	define('BOTBANISH_REWRITECOND_END', '<br>' . 'RewriteRule .* - [G,L,F]' . '<br>');

	// BotBanish .htaccess tags

	define('BOTBANISH_BOT_REWRITECOND_2_4', 'RewriteCond %%{HTTP_USER_AGENT} ');
	define('BOTBANISH_TAG_IP_START_2_4', BOTBANISH_TAG_IP_START);
	define('BOTBANISH_TAG_IP_END_2_4', BOTBANISH_TAG_IP_END);
	define('BOTBANISH_TAG_BOT_START_2_4', BOTBANISH_TAG_BOT_START);
	define('BOTBANISH_TAG_BOT_END_2_4', BOTBANISH_TAG_BOT_END);
	define('BOTBANISH_TAG_BOT_REWRITECOND_START_2_4', sprintf($section, $start, 'BotBanish BOT Start (REWRITECOND)', $end));
	define('BOTBANISH_TAG_BOT_REWRITECOND_END_2_4', sprintf($section, $start, 'BotBanish BOT End (REWRITECOND)', $end));
	define('BOTBANISH_LOCAL_ADDR', '::1,127.0.0.1');
}

function BotBanishRemoveCode() {

	global $themedir, $sourcedir, $boarddir;
	
	$files = array(
	
		$themedir. '/Register.template.php',
		$themedir . '/index.template.php',
		$themedir . '/Packages.template.php',
		$themedir . '/Profile.template.php',
		$sourcedir . '/QueryString.php',
		$boarddir . '/index.php',
		$sourcedir . '/LogInOut.php',
	);

	$items = array(
		array(
			'type' => 'rules',
			'rules' => array(
				array('rule_start' => '// ' . BOTBANISH_CODE_START, 'rule_end' => '// ' . BOTBANISH_CODE_END),
			)
		)
	);
	
	foreach ($files as $file)
		BotBanishUnModifyRuleBlocks($file, $items);
}

function BotBanishUnModifyRuleBlocks($filename, $items) {
	
	if (!file_exists($filename))
		return;

	$source = BotBanishReadFile($filename);

	if (empty($source))
		return;

	foreach ($items as $item) {

		switch($item['type']) {

			case 'data':

				$source = BotBanishRemoveData($item , $source);

				break;

			case 'rules':

				foreach ($item['rules'] as $rule)
					$source = BotBanishRemoveRuleBlock("\n\t" . $rule['rule_start'] . "\n", "\n\t" . $rule['rule_end'] . "\n", $source);

				break;
		}
	}

	BotBanishWriteFile($filename, $source);
}

function BotBanishRemoveRuleBlock($start_entry, $end_entry, $source_data) {
	
	$lines = explode($start_entry, $source_data);
	$str = '';
	
	foreach ($lines as $line) {
		
		$items = explode($end_entry, $line);
		
		if (count($items) < 2)
			
			$str .= $line;
		else
			$str .= $items[1];
	}
	
	return $str;
}

function BotBanishRemoveData($data, $source) {

	if (!is_array($data))
		$data = array($data);

	str_replace($data, '', $source);
	return $source;
}

function BotBanishRemovePackageList() {

	global $boarddir, $db_prefix, $context;

	// Remove all evidence of package Last in First Out

	$sql = 'SELECT `value` FROM ' . $db_prefix . 'settings WHERE `variable` = "smfVersion"';
	$rows = BotBanishExecuteSQL($sql);

	if (!is_array($rows))
		die('No SMF Version Present');

	define('SMF_VERSION', $rows[0]['value']);
	define('SMF_FULL_VERSION', 'SMF ' . SMF_VERSION);

	$forum_version = $rows[0]['value'];

	$sql = 'SELECT id_install, filename, package_id, name, version, id_member_installed, member_installed,
					time_installed, id_member_removed, member_removed, time_removed, install_state, failed_steps, themes_installed, db_changes
					FROM ' . $db_prefix . 'log_packages WHERE filename LIKE "%BotBanish%"
					ORDER BY time_installed DESC';

	$rows = BotBanishExecuteSQL($sql);

	// If no information is found in the log_packages table;
	// scan the package folder for an archive file to use for uninstall

	if (!is_array($rows)) {

		$files = glob($boarddir . '/Packages/BotBanish*');
		rsort($files, SORT_STRING);
		$rows = array();
		$i = 0;

		foreach ($files as $file) {

			$rows[$i]['id_install'] = 99999;
			$rows[$i]['filename'] = $file;
			$rows[$i]['package_id'] = 99999;
			$rows[$i]['name'] = $file;
			$rows[$i]['version'] = 99999;
			$rows[$i]['id_member_installed'] = 0;
			$rows[$i]['member_installed'] = 0;
			$rows[$i]['time_installed'] = time();
			$rows[$i]['id_member_removed'] = 0;
			$rows[$i]['member_removed'] = 'Admin';
			$rows[$i]['time_removed'] = time();
			$rows[$i]['install_state'] = 1;
			$rows[$i]['failed_steps'] = BotBanishSafeSerialize(array());
			$rows[$i]['themes_installed'] = 1;
			$rows[$i]['db_changes'] = '';
		}
	}

	foreach ($rows as $row) {

		$context['themes_locked'] = true;

//		PackageUninstall($row);

		if (!file_exists($boarddir . 'Packages/' . $row['filename'])) {

			$sql = 'DELETE FROM ' . $db_prefix . 'log_packages WHERE id_install = "' . $row['id_install'] . '"';
			BotBanishExecuteSQL($sql);
		}
	}

	$context['themes_locked'] = false;
}

function loadLanguage($languagefile) {

	global $txt, $boarddir;

	include_once($boarddir . '/Themes/default/languages/' . $languagefile . '.english.php');
}

function BotBanishCleanupHTACCESS() {

	echo 'BotBanish .htaccess File Cleanup Started<br><br>';

	//=================================================================================================
	// Check to see if we have information in the .htaccess file, if so we will try to remove it
	//=================================================================================================

	$htaccess_array = array($_SERVER['DOCUMENT_ROOT']);

	foreach ($htaccess_array as $htaccess_name) {

		$htaccess_data = BotBanishHTACCESSReadFile($htaccess_name . '.htaccess');

		// Attempt the group entry

		$htaccess_data = BotBanishHTACCESSRemoveRuleBlock(BOTBANISH_HTACCESS_START, BOTBANISH_HTACCESS_END, $htaccess_data);
		$htaccess_data = BotBanishHTACCESSRemoveRuleBlock(BOTBANISH_XMLRPC_START, BOTBANISH_XMLRPC_END, $htaccess_data);
		$htaccess_data = BotBanishHTACCESSRemoveRuleBlock(BOTBANISH_WPCONFIG_START, BOTBANISH_WPCONFIG_END, $htaccess_data);

		$htaccess_data = BotBanishHTACCESSRemoveRuleBlock(BOTBANISH_RULE_START, BOTBANISH_RULE_END, $htaccess_data);
		$htaccess_data = BotBanishHTACCESSRemoveRuleBlock(BOTBANISH_CODE_START, BOTBANISH_CODE_END, $htaccess_data);
		$htaccess_data = BotBanishHTACCESSRemoveRuleBlock(BOTBANISH_TAG_BOT_REWRITE_START, BOTBANISH_TAG_BOT_REWRITE_END, $htaccess_data);
		$htaccess_data = BotBanishHTACCESSRemoveRuleBlock(BOTBANISH_TAG_IP_START, BOTBANISH_TAG_IP_END, $htaccess_data);
		$htaccess_data = BotBanishHTACCESSRemoveRuleBlock(BOTBANISH_TAG_BOT_START, BOTBANISH_TAG_BOT_END, $htaccess_data);
		$htaccess_data = BotBanishHTACCESSRemoveRuleBlock(BOTBANISH_TAG_IP_START_2_4, BOTBANISH_TAG_IP_END_2_4, $htaccess_data);
		$htaccess_data = BotBanishHTACCESSRemoveRuleBlock(BOTBANISH_TAG_BOT_START_2_4, BOTBANISH_TAG_BOT_END_2_4, $htaccess_data);

		BotBanishHTACCESSWriteFile($htaccess_data, array(), $htaccess_name . '.htaccess');
	}

	echo '<br>BotBanish .htaccess File Cleanup Complete<br><br>';
}

function BotBanishHTACCESSRemoveRuleBlock($start_entry, $end_entry, $htaccess_data) {

	if (empty($htaccess_data)) return $htaccess_data;

	$entries = array($start_entry, $end_entry);
	$new_entries = array();

	$entries = array_merge($entries, $new_entries);
	$tags = array();

	foreach ($entries as $key => $value)
		$tags[$key] = array_keys($htaccess_data, $value, false);

	$i = 0;
	$index = array();

	foreach ($tags as $key => $value) {

		if (!empty($tags[$key])) {

			foreach ($value as $key1 => $value1)
				$index[$value1] = $value1;
		}
	}

	ksort($index);

	$num = count($index);

	if (intval($num / 2) != ($num / 2)) {

		echo('Mis-Matched Begin/End Markers Found - Begin: ' . $start_entry . ' - End: ' . $end_entry);
		return;
	}

	$start = 0;
	$end = 0;

	foreach ($index as $key => $value) {

		$end = empty($end) && !empty($start) ? $value : $end;
		$start = empty($start) ? $value : $start;

		if (!empty($end)) {

			for ($i = $start; $i <= $end; $i++)
				unset ($htaccess_data[$i]);

			$start = 0;
			$end = 0;
		}
	}

	return $htaccess_data;
}

function BotBanishHTACCESSReadFile($htaccess_name = '') {

	$lines = array();

	if (file_exists($htaccess_name))
		$lines = file($htaccess_name, FILE_IGNORE_NEW_LINES);

	return $lines;
}

function BotBanishHTACCESSWriteFile($htaccess_data, $lines, $htaccess_name = '') {

	if (empty($htaccess_name))
		return;

	// If the files folder does not already exist, do NOTHING!!!

	$dir = str_ireplace(basename($htaccess_name), '', $htaccess_name);

	if (!is_dir($dir))
		return;

	$lines = !is_array($lines) ? array($lines) : $lines;
	$htaccess_data = !is_array($htaccess_data) ? array($htaccess_data) : $htaccess_data;

	// Write the new file

	$htaccess_data = array_merge($lines , $htaccess_data);
	$data = implode('<br>', $htaccess_data);

	$file = fopen($htaccess_name, 'w');

	if (isset($file)) {

		$output = BotBanish_UTF8_Encode ($data);
		$output = BotBanishRemoveExtraCRLF($output);

		fwrite ($file, $output);
		fflush($file);
		fclose($file);
	}
}

function BotBanish_UTF8_Encode(string $str): string {

	if (function_exists('mb_convert_encoding')) {

		$output = mb_convert_encoding($str, 'UTF-8', mb_list_encodings());

	} else {

		if (function_exists('iconv')) {

			$output = iconv('ISO-8859-1', 'UTF-8', $str);

		} else {

			$str .= $str;
			$len = strlen($str);

			for ($i = $len >> 1, $j = 0; $i < $len; ++$i, ++$j) {

				switch (true) {

					case $str[$i] < "\x80": $str[$j] = $str[$i]; break;
					case $str[$i] < "\xC0": $str[$j] = "\xC2"; $str[++$j] = $str[$i]; break;
					default: $str[$j] = "\xC3"; $str[++$j] = \chr(\ord($str[$i]) - 64); break;
				}
			}

			$output = substr($str, 0, $j);
		}
	}

    return $output;
}

function BotBanishRemoveExtraCRLF($data) {

	$data = str_replace('<br>' . '<br>' . '<br>', '<br>', $data);
	return $data;
}

function BotBanishDeleteDirectorySPL($dir) {

    if (!file_exists($dir))
        return true;

    $iterator = new RecursiveDirectoryIterator($dir, RecursiveDirectoryIterator::SKIP_DOTS);
    $files = new RecursiveIteratorIterator($iterator, RecursiveIteratorIterator::CHILD_FIRST);

    foreach ($files as $fileinfo) {

        if ($fileinfo->isDir())

            rmdir($fileinfo->getRealPath());
        else
            unlink($fileinfo->getRealPath());
    }

    return rmdir($dir);
}

function BotBanishFolderDeletion() {

	echo 'BotBanish Folder Deletion Started<br><br>';

	$dir1 = substr(str_replace('\\', '/', BOTBANISH_DIR), 0, strrpos(BOTBANISH_DIR, '/'));
	$dir2 = substr($dir1, 0, strrpos($dir1, '/'));
	$dir3 = substr($dir2, 0, strrpos($dir2, '/'));
	$dir4 = substr($dir3, 0, strrpos($dir3, '/')) . '/BotBanish_Data';

	$folders = array($dir1, $dir2, $dir4);

	foreach ($folders as $folder)
		BotBanishDeleteFolder($folder . '/');

	echo '<br>BotBanish Folder Deletion Complete<br><br>';
	return $folders;
}

function BotBanishDeleteFolder($dirPath) {

	if (BotBanishDeleteDirectorySPL($dirPath))

		echo "&emsp;Directory deleted successfully - " . $dirPath . '<br>';
	else
		echo "&emsp;Failed to delete the directory - " . $dirPath . '<br>';
}

function BotBanishTableDeletion($system) {

	echo 'BotBanish Table Deletetion Started<br><br>';

	BotBanishShowBotBanishTableInfo(true);

	if ($system == 'WORDPRESS') {

		$sql = 'DELETE FROM `' . BOTBANISH_TABLE_PREFIX . 'options` WHERE `option_name` LIKE "%botbanish%"';
		BotBanishExecuteSQL($sql);
		echo '<br>&emsp; Deleted - BotBanish WordPress Options<br>';
	}

	echo '<br>BotBanish Table Deletetion Complete<br><br>';
}

function BotBanishFileDeletion($folders, $system) {

	echo 'BotBanish File Deletion Started<br><br>';

	// Attempt to cleanup all files that we may have installed or created that may have been left behind

	$files = array(
		'BotBanish_RegisterAccount.html',
		'BotBanish_RegisterAccount.php',
		'Settings_Client.php',
		'BotBanish_Settings.php',
	);

	switch ($system) {

		case 'WORDPRESS':

			$files[] = 'BotBanish_WP_Settings.php';
			$folders[] = ABSPATH;
			break;

		case 'SMF':

			global $boarddir;

			$folders[] = $boarddir;
			break;
	}

	if (!empty($folders)) {

		foreach ($folders as $folder) {

			foreach ($files as $file) {

				$filename = $folder . '/' . $file;

				if (file_exists($filename)) {

					unlink($filename);
					echo '&emsp;Deleted - ' . $filename . '<br>';
				}
			}
		}
	}

	echo '<br>BotBanish File Deletion Complete<br><br>';
}


function BotBanishReadFile($filename) {

	global $BotBanishText;

	$data = '';

	if (file_exists($filename) && (filesize($filename) > 0)){

		$data = file_get_contents($filename);
	}else{
		echo $filename . $BotBanishText['BotBanish_NotFound'];
	}

	return $data;
}

function BotBanishWriteFile($filename, $data, $append = false) {

	if (empty($filename)) {

		BotBanishLogError('BotBanishWriteFile() - No filename present', '', 'Error');
		return;
	}

	if (empty($data)) {

		BotBanishLogError('BotBanishWriteFile() - No data present', '', 'Error');
		return;
	}

	$data = BotBanish_EncodeToUtf8($data);

	$folder = dirname($filename) . '/';
	if (!is_dir($folder)) @mkdir ($folder, 0755, true);

	if (!file_exists($filename)) $append = false;

	if ($append)

		$bytes = file_put_contents($filename, $data, FILE_APPEND);
	else
		$bytes = file_put_contents($filename, $data);
}

function BotBanish_EncodeToUtf8($string) {
     return mb_convert_encoding($string, "UTF-8", mb_detect_encoding($string, "UTF-8, ISO-8859-1, ISO-8859-15", true));
}

function BotBanish_EncodeToIso($string) {
     return mb_convert_encoding($string, "ISO-8859-1", mb_detect_encoding($string, "UTF-8, ISO-8859-1, ISO-8859-15", true));
}

function BotBanishSafeUnserialize($data) {

	if (BotBanishIsSerialized($data)) {

		$tmp = stripslashes($data);
		BotBanishRestoreErrorHandler();
		$str = @unserialize($tmp);
		BotBanishSetErrorHandler();

		if (!is_array($str))
			$str = unserialize($data);

		if (!is_array($str)) {

			echo('Unserialization Error: ' . $data . '<br>' . '<br>' . '$tmp = ' . $tmp . '<br>' . '<br>' . '$str = ' . $str);
			$str = array();
		}

	} else {

		$str = $data;
	}

	return $str;
}

function BotBanishSafeSerialize($data) {

	$str = $data;

	if (!BotBanishIsSerialized($data)) {

		if (is_array($data)) {

			$str = addslashes(serialize($data));
			$tmp = unserialize(stripslashes($str));

			if (!is_array($tmp)) {

				echo('Serialization Error: ' . $data . '<br>' . '<br>' . '$tmp = ' . $tmp . '<br>' . '<br>' . '$str = ' . $str);
				$str = array();
			}
		}
	}

	return $str;
}

function BotBanishIsSerialized( $data, $strict = true ) {

    // If it isn't a string, it isn't serialized. : ''
    if ( ! is_string( $data ) ) {
        return false;
    }
    $data = trim( $data );
    if ( 'N;' === $data ) {
        return true;
    }
    if ( strlen( $data ) < 4 ) {
        return false;
    }
    if ( ':' !== $data[1] ) {
        return false;
    }
    if ( $strict ) {
        $lastc = substr( $data, -1 );
        if ( ';' !== $lastc && '}' !== $lastc ) {
            return false;
        }
    } else {
        $semicolon = strpos( $data, ';' );
        $brace     = strpos( $data, '}' );
        // Either ; or } must exist.
        if ( false === $semicolon && false === $brace ) {
            return false;
        }
        // But neither must be in the first X characters.
        if ( false !== $semicolon && $semicolon < 3 ) {
            return false;
        }
        if ( false !== $brace && $brace < 4 ) {
            return false;
        }
    }
    $token = $data[0];
    switch ( $token ) {
        case 's':
            if ( $strict ) {
                if ( '"' !== substr( $data, -2, 1 ) ) {
                    return false;
                }
            } elseif ( false === strpos( $data, '"' ) ) {
                return false;
            }
            // Or else fall through.
        case 'a':
        case 'O':
            return (bool) preg_match( "/^{$token}:[0-9]+:/s", $data );
        case 'b':
        case 'i':
        case 'd':
            $end = $strict ? '$' : '';
            return (bool) preg_match( "/^{$token}:[0-9.E+-]+;$end/", $data );
    }
    return false;
}
?>